<?php
/**
 * AutoCheck Pro - Report Viewer
 * Displays generated inspection reports (PDF)
 */

// Get report ID
$reportId = isset($_GET['id']) ? preg_replace('/[^A-Za-z0-9\-]/', '', $_GET['id']) : '';

if (empty($reportId)) {
    header('Location: inspection.php?error=' . urlencode('No report ID provided.'));
    exit;
}

$reportPath = __DIR__ . '/reports/' . $reportId . '.pdf';

if (!file_exists($reportPath)) {
    header('Location: inspection.php?error=' . urlencode('Report not found.'));
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inspection Report - <?php echo htmlspecialchars($reportId); ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Arimo:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .report-actions {
            background: var(--secondary);
            padding: 15px 0;
            position: fixed;
            width: 100%;
            top: 0;
            z-index: 1000;
        }
        .report-actions .container {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .report-actions .logo {
            color: white;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .report-actions .logo h1 {
            font-size: 1.3rem;
        }
        .report-actions .logo span {
            color: var(--primary);
        }
        .action-buttons {
            display: flex;
            gap: 15px;
        }
        .action-buttons .btn {
            padding: 10px 25px;
            font-size: 0.9rem;
        }
        .pdf-frame {
            margin-top: 80px;
            width: 100%;
            height: calc(100vh - 80px);
            border: none;
        }
        .success-banner {
            background: linear-gradient(135deg, #10b981, #059669);
            color: white;
            padding: 20px;
            text-align: center;
            margin-top: 70px;
        }
        .success-banner h2 {
            font-size: 1.5rem;
            margin-bottom: 10px;
        }
        .success-banner p {
            opacity: 0.9;
        }
        @media (max-width: 768px) {
            .action-buttons {
                flex-wrap: wrap;
            }
            .action-buttons .btn {
                padding: 8px 15px;
                font-size: 0.85rem;
            }
        }
    </style>
</head>
<body>
    <!-- Action Bar -->
    <div class="report-actions">
        <div class="container">
            <a href="index.php" class="logo">
                <span class="logo-text" style="font-size: 1.2rem;">VERIDANZ <span>EMPIRE</span></span>
            </a>
            <div class="action-buttons">
                <a href="inspection.php" class="btn btn-secondary" style="border-color: white; color: white;">
                    <i class="fas fa-plus"></i> New Inspection
                </a>
                <a href="download.php?id=<?php echo htmlspecialchars($reportId); ?>" class="btn btn-accent">
                    <i class="fas fa-download"></i> Download PDF
                </a>
            </div>
        </div>
    </div>

    <!-- Success Banner -->
    <div class="success-banner">
        <h2><i class="fas fa-check-circle"></i> Report Generated Successfully!</h2>
        <p>Report ID: <?php echo htmlspecialchars($reportId); ?> | You can download or share this PDF report.</p>
    </div>

    <!-- PDF Frame -->
    <iframe src="reports/<?php echo htmlspecialchars($reportId); ?>.pdf" class="pdf-frame" id="pdfFrame"></iframe>
</body>
</html>
