<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vehicle Inspection Form - Veridanz Empire</title>
    <link href="https://fonts.googleapis.com/css2?family=Arimo:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <!-- Header -->
    <header>
        <nav class="container">
            <a href="index.php" class="logo">
                <span class="logo-text">VERIDANZ <span>EMPIRE</span></span>
            </a>
            <ul class="nav-links">
                <li><a href="index.php">Home</a></li>
                <li><a href="index.php#features">Features</a></li>
                <li><a href="index.php#how-it-works">How It Works</a></li>
                <li><a href="inspection.php" class="active">Inspection Form</a></li>
                <li><a href="index.php#contact">Contact</a></li>
            </ul>
            <a href="inspection.php" class="nav-btn">Start Inspection</a>
            <div class="mobile-menu">
                <i class="fas fa-bars"></i>
            </div>
        </nav>
    </header>

    <!-- Inspection Form Section -->
    <section class="inspection-form-section" style="padding-top: 120px;">
        <div class="container">
            <div class="form-container">
                <div class="form-header">
                    <h2><i class="fas fa-clipboard-check"></i> Vehicle Inspection Form</h2>
                    <p>Fill out the form below to generate a professional inspection report</p>
                </div>

                <?php if (isset($_GET['success'])): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i>
                    Inspection report generated successfully! <a href="reports/<?php echo htmlspecialchars($_GET['report']); ?>">Download Report</a>
                </div>
                <?php endif; ?>

                <?php if (isset($_GET['error'])): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-circle"></i>
                    <?php echo htmlspecialchars($_GET['error']); ?>
                </div>
                <?php endif; ?>

                <form action="process.php" method="POST" enctype="multipart/form-data" id="inspectionForm">

                    <!-- Inspector Information -->
                    <div class="form-section">
                        <h3 style="color: var(--secondary); margin-bottom: 20px; font-size: 1.2rem;">
                            <i class="fas fa-user"></i> Inspector Information
                        </h3>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="inspector_name">Inspector Name *</label>
                                <input type="text" id="inspector_name" name="inspector_name" required placeholder="Enter your name">
                            </div>
                            <div class="form-group">
                                <label for="inspection_date">Inspection Date *</label>
                                <input type="date" id="inspection_date" name="inspection_date" required value="<?php echo date('Y-m-d'); ?>">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="company_name">Company/Dealership Name</label>
                                <input type="text" id="company_name" name="company_name" placeholder="Optional">
                            </div>
                            <div class="form-group">
                                <label for="inspector_email">Email Address</label>
                                <input type="email" id="inspector_email" name="inspector_email" placeholder="Optional">
                            </div>
                        </div>
                    </div>

                    <!-- Vehicle Information -->
                    <div class="form-section" style="margin-top: 40px;">
                        <h3 style="color: var(--secondary); margin-bottom: 20px; font-size: 1.2rem;">
                            <i class="fas fa-car"></i> Vehicle Information
                        </h3>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="vehicle_make">Make *</label>
                                <input type="text" id="vehicle_make" name="vehicle_make" required placeholder="e.g., Toyota">
                            </div>
                            <div class="form-group">
                                <label for="vehicle_model">Model *</label>
                                <input type="text" id="vehicle_model" name="vehicle_model" required placeholder="e.g., Camry">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="vehicle_year">Year *</label>
                                <input type="number" id="vehicle_year" name="vehicle_year" required min="1900" max="<?php echo date('Y') + 1; ?>" placeholder="e.g., 2023">
                            </div>
                            <div class="form-group">
                                <label for="vehicle_color">Color</label>
                                <input type="text" id="vehicle_color" name="vehicle_color" placeholder="e.g., Silver">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="vin_number">VIN Number</label>
                                <input type="text" id="vin_number" name="vin_number" placeholder="17-character VIN" maxlength="17">
                            </div>
                            <div class="form-group">
                                <label for="license_plate">License Plate</label>
                                <input type="text" id="license_plate" name="license_plate" placeholder="e.g., ABC 1234">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="mileage">Mileage (km/miles) *</label>
                                <input type="number" id="mileage" name="mileage" required min="0" placeholder="e.g., 45000">
                            </div>
                            <div class="form-group">
                                <label for="transmission">Transmission</label>
                                <select id="transmission" name="transmission">
                                    <option value="">Select Transmission</option>
                                    <option value="automatic">Automatic</option>
                                    <option value="manual">Manual</option>
                                    <option value="cvt">CVT</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Photo Upload Section -->
                    <div class="photo-upload-section">
                        <h3><i class="fas fa-camera"></i> Vehicle Photos</h3>
                        <p style="color: var(--text-light); margin-bottom: 20px;">Upload photos of the vehicle from different angles (max 8 photos, 5MB each)</p>
                        <div class="upload-grid">
                            <div class="upload-box" data-index="0">
                                <div class="upload-icon"><i class="fas fa-plus"></i></div>
                                <span>Front View</span>
                                <input type="file" name="photos[]" accept="image/*" data-label="Front View">
                                <button type="button" class="remove-btn"><i class="fas fa-times"></i></button>
                            </div>
                            <div class="upload-box" data-index="1">
                                <div class="upload-icon"><i class="fas fa-plus"></i></div>
                                <span>Rear View</span>
                                <input type="file" name="photos[]" accept="image/*" data-label="Rear View">
                                <button type="button" class="remove-btn"><i class="fas fa-times"></i></button>
                            </div>
                            <div class="upload-box" data-index="2">
                                <div class="upload-icon"><i class="fas fa-plus"></i></div>
                                <span>Left Side</span>
                                <input type="file" name="photos[]" accept="image/*" data-label="Left Side">
                                <button type="button" class="remove-btn"><i class="fas fa-times"></i></button>
                            </div>
                            <div class="upload-box" data-index="3">
                                <div class="upload-icon"><i class="fas fa-plus"></i></div>
                                <span>Right Side</span>
                                <input type="file" name="photos[]" accept="image/*" data-label="Right Side">
                                <button type="button" class="remove-btn"><i class="fas fa-times"></i></button>
                            </div>
                            <div class="upload-box" data-index="4">
                                <div class="upload-icon"><i class="fas fa-plus"></i></div>
                                <span>Dashboard</span>
                                <input type="file" name="photos[]" accept="image/*" data-label="Dashboard">
                                <button type="button" class="remove-btn"><i class="fas fa-times"></i></button>
                            </div>
                            <div class="upload-box" data-index="5">
                                <div class="upload-icon"><i class="fas fa-plus"></i></div>
                                <span>Interior</span>
                                <input type="file" name="photos[]" accept="image/*" data-label="Interior">
                                <button type="button" class="remove-btn"><i class="fas fa-times"></i></button>
                            </div>
                            <div class="upload-box" data-index="6">
                                <div class="upload-icon"><i class="fas fa-plus"></i></div>
                                <span>Engine Bay</span>
                                <input type="file" name="photos[]" accept="image/*" data-label="Engine Bay">
                                <button type="button" class="remove-btn"><i class="fas fa-times"></i></button>
                            </div>
                            <div class="upload-box" data-index="7">
                                <div class="upload-icon"><i class="fas fa-plus"></i></div>
                                <span>Additional</span>
                                <input type="file" name="photos[]" accept="image/*" data-label="Additional">
                                <button type="button" class="remove-btn"><i class="fas fa-times"></i></button>
                            </div>
                        </div>
                    </div>

                    <!-- Inspection Categories -->
                    <div class="inspection-categories">
                        <h3><i class="fas fa-tasks"></i> Inspection Checklist</h3>
                        <p style="color: var(--text-light); margin-bottom: 20px;">Rate each area of the vehicle</p>

                        <div class="category-grid">
                            <!-- Exterior -->
                            <div class="category-item">
                                <label>
                                    <input type="checkbox" name="checks[]" value="exterior_body">
                                    <span>Exterior Body Condition</span>
                                </label>
                                <select name="rating_exterior_body" class="rating-select">
                                    <option value="excellent">Excellent</option>
                                    <option value="good" selected>Good</option>
                                    <option value="fair">Fair</option>
                                    <option value="poor">Poor</option>
                                </select>
                            </div>
                            <div class="category-item">
                                <label>
                                    <input type="checkbox" name="checks[]" value="paint">
                                    <span>Paint Condition</span>
                                </label>
                                <select name="rating_paint" class="rating-select">
                                    <option value="excellent">Excellent</option>
                                    <option value="good" selected>Good</option>
                                    <option value="fair">Fair</option>
                                    <option value="poor">Poor</option>
                                </select>
                            </div>
                            <div class="category-item">
                                <label>
                                    <input type="checkbox" name="checks[]" value="glass">
                                    <span>Glass & Windows</span>
                                </label>
                                <select name="rating_glass" class="rating-select">
                                    <option value="excellent">Excellent</option>
                                    <option value="good" selected>Good</option>
                                    <option value="fair">Fair</option>
                                    <option value="poor">Poor</option>
                                </select>
                            </div>
                            <div class="category-item">
                                <label>
                                    <input type="checkbox" name="checks[]" value="lights">
                                    <span>Lights & Signals</span>
                                </label>
                                <select name="rating_lights" class="rating-select">
                                    <option value="excellent">Excellent</option>
                                    <option value="good" selected>Good</option>
                                    <option value="fair">Fair</option>
                                    <option value="poor">Poor</option>
                                </select>
                            </div>

                            <!-- Mechanical -->
                            <div class="category-item">
                                <label>
                                    <input type="checkbox" name="checks[]" value="engine">
                                    <span>Engine Performance</span>
                                </label>
                                <select name="rating_engine" class="rating-select">
                                    <option value="excellent">Excellent</option>
                                    <option value="good" selected>Good</option>
                                    <option value="fair">Fair</option>
                                    <option value="poor">Poor</option>
                                </select>
                            </div>
                            <div class="category-item">
                                <label>
                                    <input type="checkbox" name="checks[]" value="transmission_check">
                                    <span>Transmission</span>
                                </label>
                                <select name="rating_transmission_check" class="rating-select">
                                    <option value="excellent">Excellent</option>
                                    <option value="good" selected>Good</option>
                                    <option value="fair">Fair</option>
                                    <option value="poor">Poor</option>
                                </select>
                            </div>
                            <div class="category-item">
                                <label>
                                    <input type="checkbox" name="checks[]" value="brakes">
                                    <span>Brakes</span>
                                </label>
                                <select name="rating_brakes" class="rating-select">
                                    <option value="excellent">Excellent</option>
                                    <option value="good" selected>Good</option>
                                    <option value="fair">Fair</option>
                                    <option value="poor">Poor</option>
                                </select>
                            </div>
                            <div class="category-item">
                                <label>
                                    <input type="checkbox" name="checks[]" value="suspension">
                                    <span>Suspension</span>
                                </label>
                                <select name="rating_suspension" class="rating-select">
                                    <option value="excellent">Excellent</option>
                                    <option value="good" selected>Good</option>
                                    <option value="fair">Fair</option>
                                    <option value="poor">Poor</option>
                                </select>
                            </div>

                            <!-- Tires & Wheels -->
                            <div class="category-item">
                                <label>
                                    <input type="checkbox" name="checks[]" value="tires">
                                    <span>Tires Condition</span>
                                </label>
                                <select name="rating_tires" class="rating-select">
                                    <option value="excellent">Excellent</option>
                                    <option value="good" selected>Good</option>
                                    <option value="fair">Fair</option>
                                    <option value="poor">Poor</option>
                                </select>
                            </div>
                            <div class="category-item">
                                <label>
                                    <input type="checkbox" name="checks[]" value="wheels">
                                    <span>Wheels & Rims</span>
                                </label>
                                <select name="rating_wheels" class="rating-select">
                                    <option value="excellent">Excellent</option>
                                    <option value="good" selected>Good</option>
                                    <option value="fair">Fair</option>
                                    <option value="poor">Poor</option>
                                </select>
                            </div>

                            <!-- Interior -->
                            <div class="category-item">
                                <label>
                                    <input type="checkbox" name="checks[]" value="seats">
                                    <span>Seats & Upholstery</span>
                                </label>
                                <select name="rating_seats" class="rating-select">
                                    <option value="excellent">Excellent</option>
                                    <option value="good" selected>Good</option>
                                    <option value="fair">Fair</option>
                                    <option value="poor">Poor</option>
                                </select>
                            </div>
                            <div class="category-item">
                                <label>
                                    <input type="checkbox" name="checks[]" value="dashboard_check">
                                    <span>Dashboard & Controls</span>
                                </label>
                                <select name="rating_dashboard_check" class="rating-select">
                                    <option value="excellent">Excellent</option>
                                    <option value="good" selected>Good</option>
                                    <option value="fair">Fair</option>
                                    <option value="poor">Poor</option>
                                </select>
                            </div>
                            <div class="category-item">
                                <label>
                                    <input type="checkbox" name="checks[]" value="ac">
                                    <span>A/C & Heating</span>
                                </label>
                                <select name="rating_ac" class="rating-select">
                                    <option value="excellent">Excellent</option>
                                    <option value="good" selected>Good</option>
                                    <option value="fair">Fair</option>
                                    <option value="poor">Poor</option>
                                </select>
                            </div>
                            <div class="category-item">
                                <label>
                                    <input type="checkbox" name="checks[]" value="electronics">
                                    <span>Electronics & Infotainment</span>
                                </label>
                                <select name="rating_electronics" class="rating-select">
                                    <option value="excellent">Excellent</option>
                                    <option value="good" selected>Good</option>
                                    <option value="fair">Fair</option>
                                    <option value="poor">Poor</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Additional Notes -->
                    <div class="form-section" style="margin-top: 40px;">
                        <h3 style="color: var(--secondary); margin-bottom: 20px; font-size: 1.2rem;">
                            <i class="fas fa-sticky-note"></i> Additional Notes
                        </h3>
                        <div class="form-group">
                            <label for="additional_notes">Comments / Observations</label>
                            <textarea id="additional_notes" name="additional_notes" placeholder="Enter any additional observations, issues found, or recommendations..."></textarea>
                        </div>
                    </div>

                    <!-- Overall Rating -->
                    <div class="form-section" style="margin-top: 40px;">
                        <h3 style="color: var(--secondary); margin-bottom: 20px; font-size: 1.2rem;">
                            <i class="fas fa-star"></i> Overall Vehicle Rating
                        </h3>
                        <div class="form-group">
                            <label for="overall_rating">Overall Condition *</label>
                            <select id="overall_rating" name="overall_rating" required>
                                <option value="">Select Overall Rating</option>
                                <option value="excellent">Excellent - Like New</option>
                                <option value="good">Good - Minor Wear</option>
                                <option value="fair">Fair - Some Issues</option>
                                <option value="poor">Poor - Needs Work</option>
                            </select>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="form-submit">
                        <button type="submit" class="btn btn-primary btn-submit">
                            <i class="fas fa-file-alt"></i>
                            Generate Inspection Report
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer>
        <div class="container">
            <div class="footer-grid">
                <div class="footer-about">
                    <a href="index.php" class="logo">
                        <span class="logo-text">VERIDANZ <span>EMPIRE</span></span>
                    </a>
                    <p>Professional vehicle inspection reports for dealerships, mechanics, and private sellers.</p>
                </div>
                <div class="footer-links">
                    <h4>Quick Links</h4>
                    <ul>
                        <li><a href="index.php">Home</a></li>
                        <li><a href="index.php#features">Features</a></li>
                        <li><a href="index.php#how-it-works">How It Works</a></li>
                        <li><a href="inspection.php">Inspection Form</a></li>
                    </ul>
                </div>
                <div class="footer-links">
                    <h4>Support</h4>
                    <ul>
                        <li><a href="#">Help Center</a></li>
                        <li><a href="#">FAQs</a></li>
                        <li><a href="#">Contact Us</a></li>
                    </ul>
                </div>
                <div class="footer-links">
                    <h4>Legal</h4>
                    <ul>
                        <li><a href="#">Privacy Policy</a></li>
                        <li><a href="#">Terms of Service</a></li>
                    </ul>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?php echo date('Y'); ?> Veridanz Empire. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script src="js/main.js"></script>
</body>
</html>
