<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Veridanz Empire - Professional Car Inspection Reports</title>
    <link href="https://fonts.googleapis.com/css2?family=Arimo:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <!-- Header -->
    <header>
        <nav class="container">
            <a href="index.php" class="logo">
                <span class="logo-text">VERIDANZ <span>EMPIRE</span></span>
            </a>
            <ul class="nav-links">
                <li><a href="index.php">Home</a></li>
                <li><a href="#features">Features</a></li>
                <li><a href="#how-it-works">How It Works</a></li>
                <li><a href="#contact">Contact</a></li>
            </ul>
            <a href="inspection.php" class="nav-btn">Start Inspection</a>
            <div class="mobile-menu">
                <i class="fas fa-bars"></i>
            </div>
        </nav>
    </header>

    <!-- Hero Section -->
    <section class="hero">
        <div class="container">
            <div class="hero-content">
                <div class="hero-text">
                    <h2>Professional <span>Car Inspection</span> Reports Made Easy</h2>
                    <p>Generate comprehensive vehicle inspection reports with photo documentation. Perfect for dealerships, mechanics, and private sellers. Get detailed, professional reports in minutes.</p>
                    <div class="hero-buttons">
                        <a href="inspection.php" class="btn btn-primary">
                            <i class="fas fa-clipboard-check"></i>
                            Start Inspection
                        </a>
                        <a href="#how-it-works" class="btn btn-secondary">
                            <i class="fas fa-play-circle"></i>
                            Learn More
                        </a>
                    </div>
                </div>
                <div class="hero-image">
                    <svg viewBox="0 0 500 400" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect x="50" y="100" width="400" height="200" rx="20" fill="#1e3a5f" opacity="0.3"/>
                        <rect x="80" y="130" width="340" height="140" rx="15" fill="#10b981" opacity="0.2"/>
                        <rect x="100" y="150" width="120" height="80" rx="10" fill="#ffffff" opacity="0.9"/>
                        <rect x="240" y="150" width="160" height="30" rx="5" fill="#ffffff" opacity="0.7"/>
                        <rect x="240" y="190" width="120" height="20" rx="5" fill="#10b981" opacity="0.8"/>
                        <rect x="240" y="220" width="80" height="15" rx="5" fill="#fbbf24" opacity="0.8"/>
                        <circle cx="160" cy="190" r="30" fill="#10b981" opacity="0.8"/>
                        <path d="M145 190 L155 200 L175 180" stroke="#ffffff" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"/>
                        <rect x="100" y="260" width="300" height="30" rx="5" fill="#ffffff" opacity="0.5"/>
                        <text x="250" y="280" text-anchor="middle" fill="#1e3a5f" font-size="12" font-weight="bold">Vehicle Inspection Report</text>
                    </svg>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="features" id="features">
        <div class="container">
            <div class="section-title">
                <h2>Why Choose AutoCheck Pro?</h2>
                <p>Everything you need to create professional vehicle inspection reports</p>
            </div>
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-camera"></i>
                    </div>
                    <h3>Photo Documentation</h3>
                    <p>Upload multiple photos for each inspection area. Document scratches, dents, and condition details with visual proof.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-file-alt"></i>
                    </div>
                    <h3>Professional Reports</h3>
                    <p>Generate beautifully formatted PDF reports that you can share with customers, buyers, or for your records.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <h3>Comprehensive Checklists</h3>
                    <p>Cover all critical areas: engine, brakes, tires, exterior, interior, and more with our detailed checklists.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <h3>Quick & Easy</h3>
                    <p>Complete inspections in minutes with our intuitive interface. No technical knowledge required.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-mobile-alt"></i>
                    </div>
                    <h3>Mobile Friendly</h3>
                    <p>Use on any device - desktop, tablet, or smartphone. Perfect for on-the-go inspections.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h3>Secure & Private</h3>
                    <p>Your data is protected with industry-standard security. Reports are only accessible to you.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- How It Works -->
    <section class="how-it-works" id="how-it-works">
        <div class="container">
            <div class="section-title">
                <h2 style="color: white;">How It Works</h2>
                <p style="color: rgba(255,255,255,0.8);">Create professional inspection reports in 4 simple steps</p>
            </div>
            <div class="steps-container">
                <div class="step">
                    <div class="step-number">1</div>
                    <h3>Enter Vehicle Info</h3>
                    <p>Add basic vehicle details like make, model, year, and VIN number</p>
                </div>
                <div class="step">
                    <div class="step-number">2</div>
                    <h3>Upload Photos</h3>
                    <p>Take and upload photos of the vehicle from multiple angles</p>
                </div>
                <div class="step">
                    <div class="step-number">3</div>
                    <h3>Complete Checklist</h3>
                    <p>Go through our comprehensive inspection checklist and rate each item</p>
                </div>
                <div class="step">
                    <div class="step-number">4</div>
                    <h3>Generate Report</h3>
                    <p>Get your professional PDF report instantly, ready to share</p>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="inspection-form-section">
        <div class="container">
            <div class="form-container" style="text-align: center;">
                <h2 style="font-size: 2.5rem; color: var(--secondary); margin-bottom: 20px;">Ready to Get Started?</h2>
                <p style="color: var(--text-light); font-size: 1.2rem; margin-bottom: 30px;">Create your first professional car inspection report today. It's quick, easy, and free to try!</p>
                <a href="inspection.php" class="btn btn-primary btn-submit">
                    <i class="fas fa-arrow-right"></i>
                    Start Your Inspection Now
                </a>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer id="contact">
        <div class="container">
            <div class="footer-grid">
                <div class="footer-about">
                    <a href="index.php" class="logo">
                        <span class="logo-text">VERIDANZ <span>EMPIRE</span></span>
                    </a>
                    <p>Professional vehicle inspection reports for dealerships, mechanics, and private sellers. Create detailed, photo-documented reports in minutes.</p>
                </div>
                <div class="footer-links">
                    <h4>Quick Links</h4>
                    <ul>
                        <li><a href="index.php">Home</a></li>
                        <li><a href="#features">Features</a></li>
                        <li><a href="#how-it-works">How It Works</a></li>
                        <li><a href="inspection.php">Inspection Form</a></li>
                    </ul>
                </div>
                <div class="footer-links">
                    <h4>Support</h4>
                    <ul>
                        <li><a href="#">Help Center</a></li>
                        <li><a href="#">FAQs</a></li>
                        <li><a href="#">Contact Us</a></li>
                        <li><a href="#">Feedback</a></li>
                    </ul>
                </div>
                <div class="footer-links">
                    <h4>Legal</h4>
                    <ul>
                        <li><a href="#">Privacy Policy</a></li>
                        <li><a href="#">Terms of Service</a></li>
                        <li><a href="#">Cookie Policy</a></li>
                    </ul>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?php echo date('Y'); ?> Veridanz Empire. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script src="js/main.js"></script>
</body>
</html>
