<?php
/**
 * AutoCheck Pro - PDF Download
 * Forces download of the PDF report
 */

// Get report ID
$reportId = isset($_GET['id']) ? preg_replace('/[^A-Za-z0-9\-]/', '', $_GET['id']) : '';

if (empty($reportId)) {
    header('Location: inspection.php?error=' . urlencode('No report ID provided.'));
    exit;
}

$reportPath = __DIR__ . '/reports/' . $reportId . '.pdf';

if (!file_exists($reportPath)) {
    header('Location: inspection.php?error=' . urlencode('Report not found.'));
    exit;
}

// Set headers for PDF download
header('Content-Type: application/pdf');
header('Content-Disposition: attachment; filename="' . $reportId . '.pdf"');
header('Content-Length: ' . filesize($reportPath));
header('Cache-Control: private, max-age=0, must-revalidate');
header('Pragma: public');

// Output the file
readfile($reportPath);
exit;
